package com.cinderellastick.ch12.myfriendsbook;

import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;

/**
 * @author Yannis Marketakis (marketak 'at' ics 'dot' forth 'dot' gr)
 */
public class PageShow {
    private String resourceUrl;
    
    public PageShow(){
        try{
            Properties properties=new Properties();
            properties.load(PageShow.class.getClassLoader().getResourceAsStream("config.properties"));
            this.resourceUrl=properties.getProperty("resourceUrl");
        }catch(IOException ex){
            ex.printStackTrace();
        }
    }
    
    public boolean urlExists(){
        try{
            Document doc=Jsoup.parse(new URL(resourceUrl),10000);
            return true;
        }catch(IOException ex){
            return false;
        }
    }
    
    public String getContents(){
        try{
            return Jsoup.parse(new URL(resourceUrl),10000).getElementsByTag("body").get(0).toString();
        }catch(IOException ex){
            return "error";
        }
    }
}